/*--------------------------------------------------------------------*
 *
 * Developed by;
 *	Neal Horman - http://www.wanlink.com
 *	Copyright (c) 2003 Neal Horman. All Rights Reserved
 *
 *	Redistribution and use in source and binary forms, with or without
 *	modification, are permitted provided that the following conditions
 *	are met:
 *	1. Redistributions of source code must retain the above copyright
 *	   notice, this list of conditions and the following disclaimer.
 *	2. Redistributions in binary form must reproduce the above copyright
 *	   notice, this list of conditions and the following disclaimer in the
 *	   documentation and/or other materials provided with the distribution.
 *	3. All advertising materials mentioning features or use of this software
 *	   must display the following acknowledgement:
 *	This product includes software developed by Neal Horman.
 *	4. Neither the name Neal Horman nor the names of any contributors
 *	   may be used to endorse or promote products derived from this software
 *	   without specific prior written permission.
 *	
 *	THIS SOFTWARE IS PROVIDED BY NEAL HORMAN AND ANY CONTRIBUTORS ``AS IS'' AND
 *	ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *	IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *	ARE DISCLAIMED.  IN NO EVENT SHALL NEAL HORMAN OR ANY CONTRIBUTORS BE LIABLE
 *	FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *	DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 *	OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 *	LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 *	OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 *	SUCH DAMAGE.
 *
 *	CVSID:  $Id: bwlist.c,v 1.17 2005/07/18 00:55:13 neal Exp $
 *
 * DESCRIPTION:
 *	application:	Spamilter
 *	module:		bwlist.c
 *--------------------------------------------------------------------*/

static char const cvsid[] = "@(#)$Id: bwlist.c,v 1.17 2005/07/18 00:55:13 neal Exp $";

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/time.h>
#include <string.h>

#include "spamilter.h"
#include "bwlist.h"
#include "misc.h"

void bwlist_init(mlfiPriv *priv)
{

	if(priv != NULL)
	{
		priv->bwlistfdsndr = -1;
		priv->bwlistfdrcpt = -1;
	}
}

int bwlist_open(mlfiPriv *priv, char *dbpath)
{
	if(priv != NULL && dbpath != NULL)
	{	char	*fn;

		if(priv->bwlistfdsndr == -1)
		{
			asprintf(&fn,"%s/db.sndr",dbpath);
			priv->bwlistfdsndr = open(fn,O_RDONLY);
			if(priv->bwlistfdsndr == -1)
				mlfi_debug("bwlist: Unable to open Sender file '%s'\n",fn);
			free(fn);
		}

		if(priv->bwlistfdrcpt == -1)
		{
			asprintf(&fn,"%s/db.rcpt",dbpath);
			priv->bwlistfdrcpt = open(fn,O_RDONLY);
			if(priv->bwlistfdrcpt == -1)
				mlfi_debug("bwlist: Unable to open Recipient file '%s'\n",fn);
			free(fn);
		}
	}
	return(priv != NULL && priv->bwlistfdsndr != -1 && priv->bwlistfdrcpt != -1);
}

void bwlist_close(mlfiPriv *priv)
{
	if(priv != NULL)
	{
		if(priv->bwlistfdsndr != -1)
		{
			close(priv->bwlistfdsndr);
			priv->bwlistfdsndr = -1;
		}
		if(priv->bwlistfdrcpt != -1)
		{
			close(priv->bwlistfdrcpt);
			priv->bwlistfdrcpt = -1;
		}
	}
}

int bwlist_get_action(int fd, char *dom, char *mbox, char *exec)
{	int	rc = BWL_A_NULL;
	char	buf[8192];
	char	adom[256],ambox[256],aaction[50],aexec[1024];
	int	action;
	char	*str =NULL;

	if(fd != -1)
	{
		memset(aexec,0,sizeof(aexec));
		if(exec != NULL)
			*exec = '\0';
		lseek(fd,0l,SEEK_SET);
		while(mlfi_fdgets(fd,buf,sizeof(buf)) >= 0)
		{
			str = strchr(buf,'#');
			if(str != NULL)
			{
				*(str--) = '\0';
				while(str >= buf && (*str ==' ' || *str == '\t'))
					*(str--) = '\0';
			}

			if(strlen(buf))
			{
				str = mlfi_strcpyadv(adom,sizeof(adom),buf,'|');
				str = mlfi_strcpyadv(ambox,sizeof(ambox),str,'|');
				str = mlfi_strcpyadv(aaction,sizeof(aaction),str,'|');

				action = (strcasecmp(aaction,"accept") == 0	? BWL_A_ACCEPT :
					strcasecmp(aaction,"reject") == 0	? BWL_A_REJECT :
					strcasecmp(aaction,"discard") == 0	? BWL_A_DISCARD :
					strcasecmp(aaction,"fail") == 0		? BWL_A_TEMPFAIL :
					strcasecmp(aaction,"tarpit") == 0	? BWL_A_TARPIT :
					strcasecmp(aaction,"exec") == 0		? BWL_A_EXEC :
					BWL_A_NULL);

				if(action == BWL_A_EXEC)
					str = mlfi_strcpyadv(aexec,sizeof(aexec),str,'|');

				if(strcasecmp(adom,dom) == 0 || 
					/* assuming adom = '.bar.com', match for '...foo.bar.com' and 'bar.com' as domain portion */
					(adom[0] == '.' && (strcasecmp(adom,dom+(strlen(dom)-strlen(adom))) == 0 || strcasecmp(adom+1,dom) == 0)) ||
					(strcmp(adom,".") == 0)
					)
				{
					if(strcasecmp(ambox,mbox) == 0)
					{
						rc = action;
						if(action == BWL_A_EXEC && strlen(aexec) && exec != NULL)
							strcpy(exec,aexec);
						mlfi_debug("bwlist_action match: '%s@%s' - action = '%s'\n",ambox,adom,aaction);
					}
					else if(strlen(ambox) == 0)
					{
						rc = action;
						if(action == BWL_A_EXEC && strlen(aexec) && exec != NULL)
							strcpy(exec,aexec);
						mlfi_debug("bwlist_action match: '%s' - action = '%s'\n",adom,aaction);
					}
				}
			}
		}

		if(rc != BWL_A_EXEC)
			*exec = '\0';
	}

	mlfi_debug("bwlist_get_action: %s@%s - action %s\n",mbox,dom,rc == 0 ? "None" :
		rc == BWL_A_ACCEPT	? "Accept" :
		rc == BWL_A_REJECT	? "Reject" :
		rc == BWL_A_DISCARD	? "Discard" :
		rc == BWL_A_TEMPFAIL	? "Fail" :
		rc == BWL_A_TARPIT	? "TarPit" :
		rc == BWL_A_EXEC	? "Exec" :
		"Unknown");


	return(rc);
}

int bwlist_query_action(mlfiPriv *priv, int list, char *dom, char *mbox, char *exec)
{	int	rc = BWL_A_NULL;

	if(priv != NULL && dom != NULL && mbox != NULL)
	{
		switch(list)
		{
			case BWL_L_SNDR:
				rc = bwlist_get_action(priv->bwlistfdsndr,dom,mbox,exec);
				break;
			case BWL_L_RCPT:
				rc = bwlist_get_action(priv->bwlistfdrcpt,dom,mbox,exec);
				break;
		}
	}

	return(rc);
}


/*--------------------------------------------------------------------*
 * $Log: bwlist.c,v $
 * Revision 1.17  2005/07/18 00:55:13  neal
 * neal - 050717 - Wall cleanup
 *
 * Revision 1.16  2004/11/26 00:08:51  neal
 * neal - 041125 - formatting change
 *
 * Revision 1.15  2004/01/27 23:49:55  neal
 * neal - 040127 - mod/fix - bwlist match logic so that last rule to match wins
 *
 * Revision 1.14  2003/10/04 16:15:10  neal
 * neal - 031004 - fix for reading blank lines
 *
 * Revision 1.13  2003/09/21 02:45:56  neal
 * neal - 030920 - fix spelling error
 *
 * Revision 1.12  2003/09/20 17:21:57  neal
 * neal - 030920 - fix pointer type assigment warnings
 *
 * Revision 1.11  2003/08/10 21:52:59  neal
 * neal - 030810 - don\'t cary the sendmail context around to places that only need the private context
 *
 * Revision 1.10  2003/07/05 00:47:34  neal
 * neal - 030704 - add Exec action
 *
 * Revision 1.9  2003/05/28 03:37:57  neal
 * neal - 030527 - include license in all files
 *
 * Revision 1.8  2003/05/02 02:48:06  neal
 * neal - 030501 - add TarPit to bwlist action types
 *
 * Revision 1.7  2003/04/25 01:18:31  neal
 * neal - 030424 - move debug emition of bwlist_action match message
 *
 * Revision 1.6  2003/04/24 04:04:50  neal
 * neal - 030423 - add support for wildcard match of sub-domains
 *
 * Revision 1.5  2003/04/14 03:52:07  neal
 * neal - 030413 - move the rdnsbl hosts to a flat ascii file
 *
 * Revision 1.4  2003/04/14 01:08:38  neal
 * neal - 030413 - move black and white lists to flat ascii files from sql.
 *
 * Revision 1.3  2003/03/24 03:46:08  neal
 * neal - 030323 - more bad pointer fixes, etc
 *
 * Revision 1.2  2003/03/24 02:23:09  neal
 * neal - 030323 - bad pointer fixes, etc
 *
 * Revision 1.1  2003/03/24 00:46:26  neal
 * neal - 030323 - add realtime black/white list of sender/recipient email addresses
 *
 *--------------------------------------------------------------------*/
