/*--------------------------------------------------------------------*
 *
 * Developed by;
 *	Neal Horman - http://www.wanlink.com
 *	Copyright (c) 2003 Neal Horman. All Rights Reserved
 *
 *	Redistribution and use in source and binary forms, with or without
 *	modification, are permitted provided that the following conditions
 *	are met:
 *	1. Redistributions of source code must retain the above copyright
 *	   notice, this list of conditions and the following disclaimer.
 *	2. Redistributions in binary form must reproduce the above copyright
 *	   notice, this list of conditions and the following disclaimer in the
 *	   documentation and/or other materials provided with the distribution.
 *	3. All advertising materials mentioning features or use of this software
 *	   must display the following acknowledgement:
 *	This product includes software developed by Neal Horman.
 *	4. Neither the name Neal Horman nor the names of any contributors
 *	   may be used to endorse or promote products derived from this software
 *	   without specific prior written permission.
 *	
 *	THIS SOFTWARE IS PROVIDED BY NEAL HORMAN AND ANY CONTRIBUTORS ``AS IS'' AND
 *	ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *	IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *	ARE DISCLAIMED.  IN NO EVENT SHALL NEAL HORMAN OR ANY CONTRIBUTORS BE LIABLE
 *	FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *	DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 *	OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 *	LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 *	OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 *	SUCH DAMAGE.
 *
 *	CVSID:  $Id: bwlist.h,v 1.9 2005/07/18 00:55:13 neal Exp $
 *
 * DESCRIPTION:
 *	application:	Spamilter
 *	module:		bwlist.h
 *--------------------------------------------------------------------*/

#ifndef _SPAMILTER_BWLIST_H_
#define _SPAMILTER_BWLIST_H_

	enum { BWL_A_NULL, BWL_A_ACCEPT, BWL_A_REJECT, BWL_A_DISCARD, BWL_A_TEMPFAIL, BWL_A_TARPIT, BWL_A_EXEC };
	enum { BWL_L_NULL, BWL_L_SNDR, BWL_L_RCPT };

	void bwlist_init(mlfiPriv *priv);
	int bwlist_open(mlfiPriv *priv, char *dbpath);
	void bwlist_close(mlfiPriv *priv);
	int bwlist_query_action(mlfiPriv *priv, int list, char *dom, char *mbox, char *exec);
#endif

/*--------------------------------------------------------------------*
 * $Log: bwlist.h,v $
 * Revision 1.9  2005/07/18 00:55:13  neal
 * neal - 050717 - Wall cleanup
 *
 * Revision 1.8  2004/11/24 17:21:14  neal
 * neal - 041124 - ensure that the header name space is unique
 *
 * Revision 1.7  2003/08/10 21:52:59  neal
 * neal - 030810 - don\'t cary the sendmail context around to places that only need the private context
 *
 * Revision 1.6  2003/07/05 00:47:34  neal
 * neal - 030704 - add Exec action
 *
 * Revision 1.5  2003/05/28 03:37:57  neal
 * neal - 030527 - include license in all files
 *
 * Revision 1.4  2003/05/02 02:48:06  neal
 * neal - 030501 - add TarPit to bwlist action types
 *
 * Revision 1.3  2003/04/14 01:08:38  neal
 * neal - 030413 - move black and white lists to flat ascii files from sql.
 *
 * Revision 1.2  2003/03/30 05:04:48  neal
 * neal - 030329 - add logic to handle DISCARD and TEMPFAIL black and white list actions
 *
 * Revision 1.1  2003/03/24 00:46:26  neal
 * neal - 030323 - add realtime black/white list of sender/recipient email addresses
 *
 *--------------------------------------------------------------------*/
