/*--------------------------------------------------------------------*
 *
 * Developed by;
 *	Neal Horman - http://www.wanlink.com
 *	Copyright (c) 2003 Neal Horman. All Rights Reserved
 *
 *	Redistribution and use in source and binary forms, with or without
 *	modification, are permitted provided that the following conditions
 *	are met:
 *	1. Redistributions of source code must retain the above copyright
 *	   notice, this list of conditions and the following disclaimer.
 *	2. Redistributions in binary form must reproduce the above copyright
 *	   notice, this list of conditions and the following disclaimer in the
 *	   documentation and/or other materials provided with the distribution.
 *	3. All advertising materials mentioning features or use of this software
 *	   must display the following acknowledgement:
 *	This product includes software developed by Neal Horman.
 *	4. Neither the name Neal Horman nor the names of any contributors
 *	   may be used to endorse or promote products derived from this software
 *	   without specific prior written permission.
 *	
 *	THIS SOFTWARE IS PROVIDED BY NEAL HORMAN AND ANY CONTRIBUTORS ``AS IS'' AND
 *	ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *	IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *	ARE DISCLAIMED.  IN NO EVENT SHALL NEAL HORMAN OR ANY CONTRIBUTORS BE LIABLE
 *	FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *	DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 *	OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 *	LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 *	OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 *	SUCH DAMAGE.
 *
 *	CVSID:  $Id: config.h,v 1.11 2005/11/24 20:31:38 neal Exp $
 *
 * DESCRIPTION:
 *	application:	spamilter
 *	module:		config.h
 *--------------------------------------------------------------------*/

#ifndef _SPAMILTER_CONFIG_H_
#define _SPAMILTER_CONFIG_H_

#if defined( __FreeBSD__) && defined(BIGSETSIZE)
	#define FD_SETSIZE 2048
#endif

#if defined(__OpenBSD__)
	#include "ns_compat.h"
#endif

#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>
#include <arpa/nameser.h>
#include <resolv.h>

#if !defined(HAVE_RES_N)
#ifndef res_state
	typedef void *res_state;
#endif
#ifndef res_ninit
	#define res_ninit(s)                    res_init()
#endif
#ifndef res_nclose
	#define res_nclose(s)			res_close()
#endif
#ifndef res_nquery
	#define res_nquery(s,d,c,t,a,l)         res_query(d,c,t,a,l)
#endif
#ifndef res_nsearch
	#define res_nsearch(s,d,c,t,a,l)        res_search(d,c,t,a,l)
#endif
#ifndef RES_NALLOC
	#define RES_NALLOC(s)			(s)
#endif
#ifndef res_nupdate
	#define res_nupdate(s,d,t)		res_update(d)
#endif
#else
	#include <res_update.h>
	#define RES_NALLOC(s)			calloc(1,sizeof(*s))
#endif

	#include <string.h>
	/*
#ifndef asprintf
	#include "nstring.h"
#endif
	*/

#endif

/*--------------------------------------------------------------------*
 * $Log: config.h,v $
 * Revision 1.11  2005/11/24 20:31:38  neal
 * neal - 051124 - changes for dns
 *
 * Revision 1.10  2005/11/20 23:34:14  neal
 * neal - 051120 - changes for dnsblupd/bind
 *
 * Revision 1.9  2005/01/10 04:48:46  neal
 * neal - 050109 - when to include nstring include header
 *
 * Revision 1.8  2004/12/14 03:12:07  neal
 * neal - 041213 - better RES_NALLOC
 *
 * Revision 1.7  2004/11/28 01:33:50  neal
 * neal - 041127 - --have-resn fixes
 *
 * Revision 1.6  2004/11/26 06:42:38  neal
 * neal - 041126 - res_?close is not supposed to be public, so do not use it
 *
 * Revision 1.5  2004/11/26 00:21:29  neal
 * neal - 041125 - add res_n support. add support for openbsd
 *
 * Revision 1.4  2004/11/24 17:21:14  neal
 * neal - 041124 - ensure that the header name space is unique
 *
 * Revision 1.3  2004/11/07 03:11:54  neal
 * neal - 041106 - pull hard defines in favor of Makefile based defines
 *
 * Revision 1.2  2004/11/05 03:55:53  neal
 * neal - 041104 - add support for client authentication
 *
 * Revision 1.1  2004/01/02 17:51:08  neal
 * neal - 040102 - add global config.h include
 *
 *--------------------------------------------------------------------*/
