/*--------------------------------------------------------------------*
 *
 * Developed by;
 *	Neal Horman - http://www.wanlink.com
 *	Copyright (c) 2003 Neal Horman. All Rights Reserved
 *
 *	Redistribution and use in source and binary forms, with or without
 *	modification, are permitted provided that the following conditions
 *	are met:
 *	1. Redistributions of source code must retain the above copyright
 *	   notice, this list of conditions and the following disclaimer.
 *	2. Redistributions in binary form must reproduce the above copyright
 *	   notice, this list of conditions and the following disclaimer in the
 *	   documentation and/or other materials provided with the distribution.
 *	3. All advertising materials mentioning features or use of this software
 *	   must display the following acknowledgement:
 *	This product includes software developed by Neal Horman.
 *	4. Neither the name Neal Horman nor the names of any contributors
 *	   may be used to endorse or promote products derived from this software
 *	   without specific prior written permission.
 *	
 *	THIS SOFTWARE IS PROVIDED BY NEAL HORMAN AND ANY CONTRIBUTORS ``AS IS'' AND
 *	ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *	IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *	ARE DISCLAIMED.  IN NO EVENT SHALL NEAL HORMAN OR ANY CONTRIBUTORS BE LIABLE
 *	FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *	DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 *	OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 *	LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 *	OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 *	SUCH DAMAGE.
 *
 *	CVSID:  $Id: dns.c,v 1.14 2005/07/18 00:55:13 neal Exp $
 *
 * DESCRIPTION:
 *	application:	spamilter
 *	module:		dns.c
 *--------------------------------------------------------------------*/

static char const cvsid[] = "@(#)$Id: dns.c,v 1.14 2005/07/18 00:55:13 neal Exp $";

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <stdarg.h>

#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/nameser.h>
#include <resolv.h>
#include <netdb.h>

#include "spamilter.h"

int dns_query_rr_a(const res_state statp, char *fmt, ...)
{	va_list	vl;
	int	x,rc = 0;
	char	*hn = NULL;

	va_start(vl,fmt);
	if(fmt != NULL && *fmt)
	{
		x = vasprintf(&hn,fmt,vl);
		if(hn != NULL && x > 0)
		{	u_char	packet[NS_PACKETSZ];

			rc = (res_nquery(statp, hn,ns_c_in,ns_t_a,packet,sizeof(packet)) == -1 ? 0 : 1);
		}

		if(hn != NULL)
			free(hn);
	}
	va_end(vl);

	return(rc);
}

int dns_rdnsbl_has_rr_a(const res_state statp, long ip, char *domain)
{
	/* this is an in_addr.arpa style lookup! */
	return(dns_query_rr_a(statp, "%u.%u.%u.%u.%s",
			((ip&0x000000ff)),
			((ip&0x0000ff00)>>8),
			((ip&0x00ff0000)>>16),
			((ip&0xff000000)>>24),
			domain));
}

int dns_hostname_ip_parse_query(long hostip, ns_msg handle, ns_sect section)
{	int	rrnum;
	ns_rr	rr;
	int	count = ns_msg_count(handle,section);
	int	match = 0;

	for(rrnum=0; rrnum<count && !match; rrnum++)
	{
		if(ns_parserr(&handle, section, rrnum, &rr) == 0 && ns_rr_type(rr) == ns_t_a)
			match = (ns_get32(ns_rr_rdata(rr)) == hostip);
	}

	return(match);
}

int dns_hostname_ip_match(const res_state statp, char *hostname, long hostip)
{	int	rc = 0;
	ns_msg	handle;
	u_char	resp[NS_PACKETSZ];
	int	match = 0;


	if(hostname != NULL && hostip != 0)
	{
		rc = res_nquery(statp, hostname,ns_c_in,ns_t_a,resp,sizeof(resp));
		if(rc > 0 && ns_initparse(resp,rc,&handle) > -1)
			match = dns_hostname_ip_parse_query(hostip,handle,ns_s_an);
	}

	return(match);
}


/*--------------------------------------------------------------------*
 * $Log: dns.c,v $
 * Revision 1.14  2005/07/18 00:55:13  neal
 * neal - 050717 - Wall cleanup
 *
 * Revision 1.13  2004/11/26 00:13:49  neal
 * neal - 041125 - add res_n support
 *
 * Revision 1.12  2004/11/05 03:25:08  neal
 * neal - 041104 - comment
 *
 * Revision 1.11  2004/01/02 17:51:08  neal
 * neal - 040102 - add global config.h include
 *
 * Revision 1.10  2003/11/26 16:32:20  neal
 * neal - 031126 - add res_close in key places, to try and close any/all dns connections
 *
 * Revision 1.9  2003/10/04 16:18:54  neal
 * neal - 031004 - support for MtaHostIpChk and MtaHostIpfwNominate
 *
 * Revision 1.8  2003/05/28 03:37:57  neal
 * neal - 030527 - include license in all files
 *
 * Revision 1.7  2003/04/07 02:29:32  neal
 * neal - 030406 - add code to dnsblupd to check for success/failure by doing a lookup following the update request.
 *
 * Revision 1.6  2003/04/03 20:36:15  neal
 * neal - 030403 - add sanity checking for fmt string passed in from caller for dns_query_rr_a
 *
 * Revision 1.5  2003/03/24 00:46:26  neal
 * neal - 030323 - add realtime black/white list of sender/recipient email addresses
 *
 * Revision 1.4  2003/02/24 20:45:53  neal
 * neal - 030224 - add dns blacklist cli util
 *
 * Revision 1.3  2003/02/24 07:27:24  neal
 * neal - 030224 - only show blacklisted zones in debug
 *
 * Revision 1.2  2003/02/24 04:11:33  neal
 * neal - 030223 - add header/footers to all files
 *
 *--------------------------------------------------------------------*/
