/*--------------------------------------------------------------------*
 *
 * Developed by;
 *	Neal Horman - http://www.wanlink.com
 *	Copyright (c) 2003 Neal Horman. All Rights Reserved
 *
 *	Redistribution and use in source and binary forms, with or without
 *	modification, are permitted provided that the following conditions
 *	are met:
 *	1. Redistributions of source code must retain the above copyright
 *	   notice, this list of conditions and the following disclaimer.
 *	2. Redistributions in binary form must reproduce the above copyright
 *	   notice, this list of conditions and the following disclaimer in the
 *	   documentation and/or other materials provided with the distribution.
 *	3. All advertising materials mentioning features or use of this software
 *	   must display the following acknowledgement:
 *	This product includes software developed by Neal Horman.
 *	4. Neither the name Neal Horman nor the names of any contributors
 *	   may be used to endorse or promote products derived from this software
 *	   without specific prior written permission.
 *	
 *	THIS SOFTWARE IS PROVIDED BY NEAL HORMAN AND ANY CONTRIBUTORS ``AS IS'' AND
 *	ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *	IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *	ARE DISCLAIMED.  IN NO EVENT SHALL NEAL HORMAN OR ANY CONTRIBUTORS BE LIABLE
 *	FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *	DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 *	OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 *	LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 *	OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 *	SUCH DAMAGE.
 *
 *	CVSID:  $Id: dnsbl.h,v 1.7 2004/11/24 17:21:14 neal Exp $
 *
 * DESCRIPTION:
 *	application:	spamilter
 *	module:		dnsbl.h
 *--------------------------------------------------------------------*/

#ifndef _SPAMILTER_DNSBL_H_
#define _SPAMILTER_DNSBL_H_

	enum { RBL_A_NULL, RBL_A_TAG, RBL_A_REJECT };
	enum { RBL_S_NULL, RBL_S_CONN, RBL_S_FROM, RBL_S_RCPT, RBL_S_EOM };

	typedef struct _rblhost
	{
		char	hostname[256];
		char	url[512];
		int	action;
		int	stage;
	} RBLHOST;

	void dnsbl_check(mlfiPriv *priv);
	RBLHOST *dnsbl_action(RBLHOST **prbls, int stage);

	void dnsbl_add_hdr(SMFICTX *ctx, RBLHOST *prbl);

	void dnsbl_open(mlfiPriv *priv, char *dbpath);
	void dnsbl_close(mlfiPriv *priv);
#endif

/*--------------------------------------------------------------------*
 * $Log: dnsbl.h,v $
 * Revision 1.7  2004/11/24 17:21:14  neal
 * neal - 041124 - ensure that the header name space is unique
 *
 * Revision 1.6  2003/08/10 21:52:59  neal
 * neal - 030810 - don\'t cary the sendmail context around to places that only need the private context
 *
 * Revision 1.5  2003/05/28 03:37:57  neal
 * neal - 030527 - include license in all files
 *
 * Revision 1.4  2003/04/14 03:52:07  neal
 * neal - 030413 - move the rdnsbl hosts to a flat ascii file
 *
 * Revision 1.3  2003/03/24 00:46:26  neal
 * neal - 030323 - add realtime black/white list of sender/recipient email addresses
 *
 * Revision 1.2  2003/02/24 04:11:33  neal
 * neal - 030223 - add header/footers to all files
 *
 *--------------------------------------------------------------------*/
