/*--------------------------------------------------------------------*
 *
 * Developed by;
 *	Neal Horman - http://www.wanlink.com
 *	Copyright (c) 2003 Neal Horman. All Rights Reserved
 *
 *	Redistribution and use in source and binary forms, with or without
 *	modification, are permitted provided that the following conditions
 *	are met:
 *	1. Redistributions of source code must retain the above copyright
 *	   notice, this list of conditions and the following disclaimer.
 *	2. Redistributions in binary form must reproduce the above copyright
 *	   notice, this list of conditions and the following disclaimer in the
 *	   documentation and/or other materials provided with the distribution.
 *	3. All advertising materials mentioning features or use of this software
 *	   must display the following acknowledgement:
 *	This product includes software developed by Neal Horman.
 *	4. Neither the name Neal Horman nor the names of any contributors
 *	   may be used to endorse or promote products derived from this software
 *	   without specific prior written permission.
 *	
 *	THIS SOFTWARE IS PROVIDED BY NEAL HORMAN AND ANY CONTRIBUTORS ``AS IS'' AND
 *	ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *	IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *	ARE DISCLAIMED.  IN NO EVENT SHALL NEAL HORMAN OR ANY CONTRIBUTORS BE LIABLE
 *	FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *	DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 *	OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 *	LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 *	OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 *	SUCH DAMAGE.
 *
 *	CVSID:  $Id: dnsblchk.c,v 1.16 2005/07/18 00:55:13 neal Exp $
 *
 * DESCRIPTION:
 *	application:	spamilter
 *	module:		dnsblchk.c
 *--------------------------------------------------------------------*/

static char const cvsid[] = "@(#)$Id: dnsblchk.c,v 1.16 2005/07/18 00:55:13 neal Exp $";

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <syslog.h>
#include <sysexits.h>
#include <string.h>
#include <fcntl.h>

#include "spamilter.h"
#include "misc.h"
#include "smisc.h"
#include "mx.h"
#include "inet.h"
#include "smtp.h"
#include "dns.h"

char	gHostnameBuf[1024];
char	*gHostname = gHostnameBuf;

int gDebug = 0;

res_state	gStatp = NULL;

int testip(long ip, char *dbpath)
{	char		*str;
	char		buf[8192];
	char		hostbuf[1024];
	int		fd;
	int		count = 0;

	asprintf(&str,"%s/db.rdnsbl",dbpath);
	fd = open(str,O_RDONLY);
	if(fd == -1)
		mlfi_debug("hostListOpen: unable to open RDNSBL host file '%s'\n",str);
	free(str);

	if(fd != -1)
	{
		lseek(fd,0l,SEEK_SET);
		while(mlfi_fdgets(fd,buf,sizeof(buf)) >= 0)
		{
			str = strchr(buf,'#');
			if(str != NULL)
			{
				*(str--) = '\0';
				while(str >= buf && (*str ==' ' || *str == '\t'))
					*(str--) = '\0';
			}

			if(strlen(buf))
			{
				mlfi_strcpyadv(hostbuf,sizeof(hostbuf),buf,'|');
				if(dns_rdnsbl_has_rr_a(gStatp,ip,hostbuf))
				{
					mlfi_debug("\t\t'%u.%u.%u.%u.%s' - Blacklisted\n",
						((ip&0x000000ff)),
						((ip&0x0000ff00)>>8),
						((ip&0x00ff0000)>>16),
						((ip&0xff000000)>>24),
						hostbuf);
					count ++;
				}
			}
		}
		close(fd);
	}

	return(count);
}

int testipstr(char *argv, char *path)
{	int	a,b,c,d;
	int	rc = -1;

	if(argv != NULL && *argv && sscanf(argv,"%u.%u.%u.%u",&a,&b,&c,&d) == 4)
		 rc = testip(mkip(a,b,c,d),path);
	else
		printf("testipstr: bogus ip address %s\n",argv);

	return(rc);
}

void testdomainmx(char *domain, char *path)
{	mx_rr_list	mxrrl;
	mx_rr_list	*rrl = &mxrrl;
	int	i,j;
	mx_rr	*rr;

	memset(rrl,0,sizeof(mx_rr_list));
	mx_get_rr_recurse_host(gStatp,mx_get_rr_bydomain(gStatp,rrl,domain));
	
	if(rrl->qty == 0)
		printf("no mx records\n");
	else
	{
		printf("Domain: %s\n",domain);
		for(i=0; i<rrl->qty; i++)
		{
			rr = &rrl->mx[i];
			printf("\tMX %u %s\n",rr->pref,rr->name);
			for(j=0; j<rr->qty; j++)
			{
				printf("\t\tA %s\n",ip2str(rr->host[j].ip));
				if(testip(rr->host[j].ip,path) == 0)
					printf("\t\tPassed\n");
			}
		}
	}
}

int main(int argc, char **argv)
{	int	c;
	int	smtprc;
	int	rc;
	char	*dbpath = "/var/db/spamilter";

	gDebug = 1;
	gStatp = RES_NALLOC(gStatp);
	res_ninit(gStatp);

	gethostname(gHostnameBuf,sizeof(gHostnameBuf)-1);
	printf("Hostname: '%s'\n",gHostnameBuf);

	while ((c = getopt(argc, argv, "i:e:")) != -1)
	{
		switch (c)
		{
			case 'i':
				if(optarg != NULL && *optarg)
				{
					if(testipstr(optarg,dbpath) == 0)
						printf("\t\tPassed\n");
				}
				else
					printf("Bogus/Missing command line arguement\n");
				break;
			case 'e':
				if(optarg != NULL && *optarg)
				{	char	*mbox = strdup(optarg);
					char	*dom = NULL;

					mboxdomainsplit(mbox,&dom);
					rc = smtp_email_address_is_deliverable(gStatp,mbox,dom,&smtprc);
					printf("mx deliverable: %d, returned: %d\n",rc,smtprc);
				}
				else
					printf("Bogus/Missing command line arguement\n");
				break;
		}
	}

	argc -= optind;
	argv += optind;

	while(argc > 0)
	{
		testdomainmx(*argv,dbpath);
		argc--;
		argv++;
	}

	res_nclose(gStatp);

	return(0);
}

/*--------------------------------------------------------------------*
 * $Log: dnsblchk.c,v $
 * Revision 1.16  2005/07/18 00:55:13  neal
 * neal - 050717 - Wall cleanup
 *
 * Revision 1.15  2004/11/28 19:03:53  neal
 * neal - 041128 - add res_ninit and res_nclose
 *
 * Revision 1.14  2004/11/26 00:20:22  neal
 * neal - 041125 - add res_n support
 *
 * Revision 1.13  2003/10/04 16:16:58  neal
 * neal - 031004 - fix for reading blank lines
 *
 * Revision 1.12  2003/09/06 19:02:10  neal
 * neal - 030906 - mod ipfwmtad nolonger runs unless uid == 0. mod spamilter logging to record reject reason in field 5. add ipfwmtad cli operators for addition and removal queuing of ipaddress to and from the fwblock list. mod spamilter all extended smtp error codes are now 5.7.1
 *
 * Revision 1.11  2003/07/15 01:59:06  neal
 * neal - 030714 - use the db.rdnsbl file for the source of the rbl host list
 *
 * Revision 1.10  2003/05/28 03:37:57  neal
 * neal - 030527 - include license in all files
 *
 * Revision 1.9  2003/05/01 02:31:35  neal
 * neal - 030430 - better smtp send delivery test handling
 *
 * Revision 1.8  2003/04/24 17:23:23  neal
 * neal - 030424 - move gethostname to a global
 *
 * Revision 1.7  2003/04/16 03:36:05  neal
 * neal - 030415 - move program options into config file
 *
 * Revision 1.6  2003/04/07 21:04:12  neal
 * neal - 030407 - report blacklisted ip addresses
 *
 * Revision 1.5  2003/03/24 02:23:09  neal
 * neal - 030323 - bad pointer fixes, etc
 *
 * Revision 1.4  2003/03/24 00:55:26  neal
 * neal - 030323 - fix dnsblchk so that it works
 *
 * Revision 1.3  2003/03/24 00:46:26  neal
 * neal - 030323 - add realtime black/white list of sender/recipient email addresses
 *
 * Revision 1.2  2003/03/02 04:11:49  neal
 * neal - 030301 - add smtp sender deliverablity check
 *
 * Revision 1.1  2003/02/24 20:45:53  neal
 * neal - 030224 - add dns blacklist cli util
 *
 *--------------------------------------------------------------------*/
