/*--------------------------------------------------------------------*
 *
 * Developed by;
 *	Neal Horman - http://www.wanlink.com
 *	Copyright (c) 2003 Neal Horman. All Rights Reserved
 *
 *	Redistribution and use in source and binary forms, with or without
 *	modification, are permitted provided that the following conditions
 *	are met:
 *	1. Redistributions of source code must retain the above copyright
 *	   notice, this list of conditions and the following disclaimer.
 *	2. Redistributions in binary form must reproduce the above copyright
 *	   notice, this list of conditions and the following disclaimer in the
 *	   documentation and/or other materials provided with the distribution.
 *	3. All advertising materials mentioning features or use of this software
 *	   must display the following acknowledgement:
 *	This product includes software developed by Neal Horman.
 *	4. Neither the name Neal Horman nor the names of any contributors
 *	   may be used to endorse or promote products derived from this software
 *	   without specific prior written permission.
 *	
 *	THIS SOFTWARE IS PROVIDED BY NEAL HORMAN AND ANY CONTRIBUTORS ``AS IS'' AND
 *	ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *	IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *	ARE DISCLAIMED.  IN NO EVENT SHALL NEAL HORMAN OR ANY CONTRIBUTORS BE LIABLE
 *	FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *	DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 *	OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 *	LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 *	OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 *	SUCH DAMAGE.
 *
 *	CVSID:  $Id: hndlrs.h,v 1.6 2004/11/24 17:21:14 neal Exp $
 *
 * DESCRIPTION:
 *	application:	spamilter
 *	module:		hndlrs.h
 *--------------------------------------------------------------------*/

#ifndef _SPAMILTER_HNDLRS_H_
#define _SPAMILTER_HNDLRS_H_

	#include "libmilter/mfapi.h"

	sfsistat mlfi_connect(SMFICTX *ctx, char *hostname, _SOCK_ADDR *hostaddr);
	sfsistat mlfi_helo(SMFICTX *ctx, char *helohost);
	sfsistat mlfi_envfrom(SMFICTX *ctx, char **envfrom);
	sfsistat mlfi_envrcpt(SMFICTX *ctx, char **argv);
	sfsistat mlfi_header(SMFICTX *ctx, char *headerf, char *headerv);
	sfsistat mlfi_body(SMFICTX *ctx, u_char *bodyp, size_t len);
	sfsistat mlfi_eom(SMFICTX *ctx);
	sfsistat mlfi_abort(SMFICTX *ctx);
	sfsistat mlfi_close(SMFICTX *ctx);

	sfsistat mlfi_cleanup(SMFICTX *);

#endif

/*--------------------------------------------------------------------*
 * $Log: hndlrs.h,v $
 * Revision 1.6  2004/11/24 17:21:14  neal
 * neal - 041124 - ensure that the header name space is unique
 *
 * Revision 1.5  2003/08/20 22:30:09  neal
 * neal - 030820 - add Microsoft file extension attachment vunerablility filter
 *
 * Revision 1.4  2003/08/10 21:53:00  neal
 * neal - 030810 - don\'t cary the sendmail context around to places that only need the private context
 *
 * Revision 1.3  2003/05/28 03:37:57  neal
 * neal - 030527 - include license in all files
 *
 * Revision 1.2  2003/02/24 04:11:33  neal
 * neal - 030223 - add header/footers to all files
 *
 *--------------------------------------------------------------------*/
