/*--------------------------------------------------------------------*
 *
 * Developed by;
 *	Neal Horman - http://www.wanlink.com
 *	Copyright (c) 2002 Neal Horman. All Rights Reserved
 *
 *	Redistribution and use in source and binary forms, with or without
 *	modification, are permitted provided that the following conditions
 *	are met:
 *	1. Redistributions of source code must retain the above copyright
 *	   notice, this list of conditions and the following disclaimer.
 *	2. Redistributions in binary form must reproduce the above copyright
 *	   notice, this list of conditions and the following disclaimer in the
 *	   documentation and/or other materials provided with the distribution.
 *	3. All advertising materials mentioning features or use of this software
 *	   must display the following acknowledgement:
 *	This product includes software developed by Neal Horman.
 *	4. Neither the name Neal Horman nor the names of any contributors
 *	   may be used to endorse or promote products derived from this software
 *	   without specific prior written permission.
 *	
 *	THIS SOFTWARE IS PROVIDED BY NEAL HORMAN AND ANY CONTRIBUTORS ``AS IS'' AND
 *	ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *	IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *	ARE DISCLAIMED.  IN NO EVENT SHALL NEAL HORMAN OR ANY CONTRIBUTORS BE LIABLE
 *	FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *	DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 *	OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 *	LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 *	OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 *	SUCH DAMAGE.
 *
 *	CVSID:  $Id: inet.h,v 1.6 2005/07/18 00:55:13 neal Exp $
 *
 * DESCRIPTION:
 *	application:	spamilter
 *	module:		inet.h
 *--------------------------------------------------------------------*/

#ifndef _SPAMILTER_INET_H_
#define _SPAMILTER_INET_H_

	#include <sys/types.h>
	#include <sys/socket.h>
	#include <netinet/in.h>
	#include <netdb.h>
	#include <sys/ioctl.h>
	#include <errno.h>

	#define INVALID_SOCKET -1
	#define SOCKET_ERROR -1

	void NetSockInitAddr(struct sockaddr_in *pSock, long ip, short port);

	int NetSockBind(int *pSd, int sockType, long ip, short port);

	int NetSockOpt(int sd, int optname, int optval);
	int NetSockOptNoLinger(int sd);

	int NetSockOpenUdpListen(short port);
	int NetSockOpenTcpPeer(long ip, short port);
	int NetSockOpenTcpListen(long ip, short port);

	void NetSockClose(int *pSd);

	int NetSockGets(int sd, char *buf, int buflenmax, int timeout);
	int NetSockPrintf(int sd, char *fmt, ...);
	int NetSockVPrintf(int sd, char *fmt, va_list vl);
#endif

/*--------------------------------------------------------------------*
 * $Log: inet.h,v $
 * Revision 1.6  2005/07/18 00:55:13  neal
 * neal - 050717 - Wall cleanup
 *
 * Revision 1.5  2004/11/24 17:21:14  neal
 * neal - 041124 - ensure that the header name space is unique
 *
 * Revision 1.4  2004/08/18 01:55:31  neal
 * neal - 040817 - add NetSockVPrintf
 *
 * Revision 1.3  2003/09/02 07:12:10  neal
 * neal - 030902 - fix segfaults. add MtaHostIpfw filter
 *
 * Revision 1.2  2003/05/28 03:37:57  neal
 * neal - 030527 - include license in all files
 *
 * Revision 1.1  2003/03/02 04:11:49  neal
 * neal - 030301 - add smtp sender deliverablity check
 *
 *--------------------------------------------------------------------*/
