/*--------------------------------------------------------------------*
 *
 * Developed by;
 *	Neal Horman - http://www.wanlink.com
 *	Copyright (c) 2003 Neal Horman. All Rights Reserved
 *
 *	Redistribution and use in source and binary forms, with or without
 *	modification, are permitted provided that the following conditions
 *	are met:
 *	1. Redistributions of source code must retain the above copyright
 *	   notice, this list of conditions and the following disclaimer.
 *	2. Redistributions in binary form must reproduce the above copyright
 *	   notice, this list of conditions and the following disclaimer in the
 *	   documentation and/or other materials provided with the distribution.
 *	3. All advertising materials mentioning features or use of this software
 *	   must display the following acknowledgement:
 *	This product includes software developed by Neal Horman.
 *	4. Neither the name Neal Horman nor the names of any contributors
 *	   may be used to endorse or promote products derived from this software
 *	   without specific prior written permission.
 *	
 *	THIS SOFTWARE IS PROVIDED BY NEAL HORMAN AND ANY CONTRIBUTORS ``AS IS'' AND
 *	ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *	IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *	ARE DISCLAIMED.  IN NO EVENT SHALL NEAL HORMAN OR ANY CONTRIBUTORS BE LIABLE
 *	FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *	DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 *	OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 *	LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 *	OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 *	SUCH DAMAGE.
 *
 *	CVSID:  $Id: misc.c,v 1.12 2003/10/04 16:16:08 neal Exp $
 *
 * DESCRIPTION:
 *	application:	spamilter
 *	module:		misc.c
 *--------------------------------------------------------------------*/

static char const cvsid[] = "@(#)$Id: misc.c,v 1.12 2003/10/04 16:16:08 neal Exp $";

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <stdarg.h>
#include <fcntl.h>
#include <sys/time.h>

extern int gDebug;

#include "misc.h"

int mlfi_debug(char *fmt, ...)
{	int	rc = 0;
	va_list	vl;

	if(gDebug && fmt != NULL)
	{
#ifdef DEBUG_TIMESTAMP
		long	now = time(NULL);
		char	time_str[128];
		char	*pstr = fmt;

		/* print leading LF's before the time stamp */
		while(*pstr == '\n')
		{
			putchar(*(pstr++));
			rc++;
		}

		/* print the time stamp */
		strftime(time_str,sizeof(time_str)-1,"%h %e %T",localtime(&now));
		rc += printf("%s [%d]: ",time_str,getpid());

		/* and finally the requested fmt string */
		va_start(vl,fmt);
		rc += vprintf(pstr,vl);
#else
		va_start(vl,fmt);
		rc += vprintf(fmt,vl);
#endif
		va_end(vl);

		fflush(stdout);
	}

	return(rc);
}

void mboxdomainsplit(char *mbox, char **domain)
{	char	*s,*d;
	int	i,l;

	if(domain != NULL)
	{
		*domain = NULL;
		for(i=0,l=strlen(mbox),d=mbox,s=mbox; i<l; i++)
		{
			if(*s != '<' && *s != '>')
			{
				*(d++) = *(s++);

				if(*(d-1) == '@')
				{
					*domain = d;
					*(d-1) = '\0';
				}
			}
			else
			{
				*d = '\0';
				s++;
			}
		}
	}
}

/* our own fgets... cept for handles */
int mlfi_fdgets(int i, char *buf, int buflenmax)
{	char	*str = buf;
	int	rc = 0;

	/* reset buffer for next iteration */
	memset(buf,0,buflenmax);

	/* read chars until EOL or EOF */
	while((rc = read(i,str,1)) == 1 && *str != '\n' && str < buf+buflenmax-1)
		str++;

	/* if we have a complete line, clean it up, and handle it */
	if(rc == 1)
	{
		if(strlen(buf))
		{
			/* trim right */
			while((*str == ' ' || *str == '\t' || *str =='\r' || *str == '\n') && str > buf)
				*(str--) = '\0';
			/* trim left */
			str = buf;
			while(*str==' ' || *str =='\t' || *str=='\r' || *str=='\n')
				str++;
			/* left justify the buffer */
			if(*str && str > buf)
			{	char *dst = buf;

				while(*str)
					*(dst++) = *(str++);
				*dst = '\0';
			}
			rc = strlen(buf);
		}
		else
			rc = 0;
	}
	else
		rc = -1;

	return(rc);
}

char *mlfi_strcpyadv(char *dst, int dstmax, char *src, char delim)
{
	if(dst != NULL)
		memset(dst,0,dstmax);
	while(src != NULL && *src && *src != delim && dstmax--)
	{
		if(*src != ' ' && *src != '\t' && *src != '\r' && *src != '\n')
			*(dst++) = *(src++);
		else
			src++;
	}

	if(*src == delim)
		src++;

	return(src);
}

/*--------------------------------------------------------------------*
 * $Log: misc.c,v $
 * Revision 1.12  2003/10/04 16:16:08  neal
 * neal - 031004 - support for --debug_timestamp. fix for reading blank lines
 *
 * Revision 1.11  2003/09/06 19:02:10  neal
 * neal - 030906 - mod ipfwmtad nolonger runs unless uid == 0. mod spamilter logging to record reject reason in field 5. add ipfwmtad cli operators for addition and removal queuing of ipaddress to and from the fwblock list. mod spamilter all extended smtp error codes are now 5.7.1
 *
 * Revision 1.10  2003/05/28 03:37:57  neal
 * neal - 030527 - include license in all files
 *
 * Revision 1.9  2003/05/01 02:31:35  neal
 * neal - 030430 - better smtp send delivery test handling
 *
 * Revision 1.8  2003/04/16 03:51:38  neal
 * neal - 030415 - fix getconf. mlfi_stradv no longer will copy CR and LF
 *
 * Revision 1.7  2003/04/16 03:36:05  neal
 * neal - 030415 - move program options into config file
 *
 * Revision 1.6  2003/04/14 03:52:07  neal
 * neal - 030413 - move the rdnsbl hosts to a flat ascii file
 *
 * Revision 1.5  2003/03/24 04:13:14  neal
 * neal - 030323 - more bad pointer fixes, etc
 *
 * Revision 1.4  2003/03/24 00:55:26  neal
 * neal - 030323 - fix dnsblchk so that it works
 *
 * Revision 1.3  2003/03/24 00:46:26  neal
 * neal - 030323 - add realtime black/white list of sender/recipient email addresses
 *
 * Revision 1.2  2003/02/24 04:11:33  neal
 * neal - 030223 - add header/footers to all files
 *
 *--------------------------------------------------------------------*/
