/*--------------------------------------------------------------------*
 *
 * Developed by;
 *	Neal Horman - http://www.wanlink.com
 *	Copyright (c) 2002 Neal Horman. All Rights Reserved
 *
 *	Redistribution and use in source and binary forms, with or without
 *	modification, are permitted provided that the following conditions
 *	are met:
 *	1. Redistributions of source code must retain the above copyright
 *	   notice, this list of conditions and the following disclaimer.
 *	2. Redistributions in binary form must reproduce the above copyright
 *	   notice, this list of conditions and the following disclaimer in the
 *	   documentation and/or other materials provided with the distribution.
 *	3. All advertising materials mentioning features or use of this software
 *	   must display the following acknowledgement:
 *	This product includes software developed by Neal Horman.
 *	4. Neither the name Neal Horman nor the names of any contributors
 *	   may be used to endorse or promote products derived from this software
 *	   without specific prior written permission.
 *	
 *	THIS SOFTWARE IS PROVIDED BY NEAL HORMAN AND ANY CONTRIBUTORS ``AS IS'' AND
 *	ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *	IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *	ARE DISCLAIMED.  IN NO EVENT SHALL NEAL HORMAN OR ANY CONTRIBUTORS BE LIABLE
 *	FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *	DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 *	OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 *	LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 *	OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 *	SUCH DAMAGE.
 *
 *	CVSID:  $Id: misc.h,v 1.9 2004/11/24 17:21:14 neal Exp $
 *
 * DESCRIPTION:
 *	application:	spamilter
 *	module:		spamilter.c
 *--------------------------------------------------------------------*/

#ifndef _SPAMILTER_MISC_H_
#define _SPAMILTER_MISC_H_

	#include <stdarg.h>

	int mlfi_debug(char *fmt, ...);

	void mboxdomainsplit(char *mbox, char **domain);

	int mlfi_fdgets(int i, char *buf, int buflenmax);
	char *mlfi_strcpyadv(char *dst, int dstmax, char *src, char delim);
#endif

/*--------------------------------------------------------------------*
 * $Log: misc.h,v $
 * Revision 1.9  2004/11/24 17:21:14  neal
 * neal - 041124 - ensure that the header name space is unique
 *
 * Revision 1.8  2003/09/06 19:02:10  neal
 * neal - 030906 - mod ipfwmtad nolonger runs unless uid == 0. mod spamilter logging to record reject reason in field 5. add ipfwmtad cli operators for addition and removal queuing of ipaddress to and from the fwblock list. mod spamilter all extended smtp error codes are now 5.7.1
 *
 * Revision 1.7  2003/05/28 03:37:57  neal
 * neal - 030527 - include license in all files
 *
 * Revision 1.6  2003/05/01 02:31:35  neal
 * neal - 030430 - better smtp send delivery test handling
 *
 * Revision 1.5  2003/04/14 03:52:07  neal
 * neal - 030413 - move the rdnsbl hosts to a flat ascii file
 *
 * Revision 1.4  2003/03/24 00:55:26  neal
 * neal - 030323 - fix dnsblchk so that it works
 *
 * Revision 1.3  2003/03/24 00:46:26  neal
 * neal - 030323 - add realtime black/white list of sender/recipient email addresses
 *
 * Revision 1.2  2003/02/24 04:11:33  neal
 * neal - 030223 - add header/footers to all files
 *
 *--------------------------------------------------------------------*/
