/*--------------------------------------------------------------------*
 *
 * Developed by;
 *	Neal Horman - http://www.wanlink.com
 *	Copyright (c) 2003 Neal Horman. All Rights Reserved
 *
 *	Redistribution and use in source and binary forms, with or without
 *	modification, are permitted provided that the following conditions
 *	are met:
 *	1. Redistributions of source code must retain the above copyright
 *	   notice, this list of conditions and the following disclaimer.
 *	2. Redistributions in binary form must reproduce the above copyright
 *	   notice, this list of conditions and the following disclaimer in the
 *	   documentation and/or other materials provided with the distribution.
 *	3. All advertising materials mentioning features or use of this software
 *	   must display the following acknowledgement:
 *	This product includes software developed by Neal Horman.
 *	4. Neither the name Neal Horman nor the names of any contributors
 *	   may be used to endorse or promote products derived from this software
 *	   without specific prior written permission.
 *	
 *	THIS SOFTWARE IS PROVIDED BY NEAL HORMAN AND ANY CONTRIBUTORS ``AS IS'' AND
 *	ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *	IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *	ARE DISCLAIMED.  IN NO EVENT SHALL NEAL HORMAN OR ANY CONTRIBUTORS BE LIABLE
 *	FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *	DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 *	OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 *	LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 *	OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 *	SUCH DAMAGE.
 *
 *	CVSID:  $Id: smtp.c,v 1.26 2005/11/22 02:54:37 neal Exp $
 *
 * DESCRIPTION:
 *	application:	spamilter
 *	module:		smtp.c
 *--------------------------------------------------------------------*/

static char const cvsid[] = "@(#)$Id: smtp.c,v 1.26 2005/11/22 02:54:37 neal Exp $";

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <syslog.h>
#include <sysexits.h>
#include <string.h>
#include <stdarg.h>

#include "spamilter.h"
#include "mx.h"
#include "inet.h"
#include "smtp.h"
#include "ifi.h"
#include "misc.h"

int smtp_get_resp(int sd, int timeout, int rcode)
{	char	buf[8192];
	int	l;
	int	rc = 0;

	do
	{
		l = NetSockGets(sd, buf, sizeof(buf), timeout);
	} while(l > 0 && buf[3] == '-');

	if(l > 0 && buf[3] == ' ')
	{
		buf[3] = '\0';
		rc = atoi(buf);
		if(rc != rcode)
		{
			buf[3]= ' ';
			mlfi_debug("\t\t'%s'\n",buf);
		}
	
	}
	else
		rc = -1;

	return(rc);
}

int smtp_send_get_resp(int sd, int timeout, int rcode, char *fmt, ...)
{	va_list	vl;
	int	rc = 0;

	va_start(vl,fmt);

	rc = NetSockVPrintf(sd,fmt,vl);
	if(rc > 0)
		rc = smtp_get_resp(sd,timeout,rcode);
	else
		mlfi_debug("smtp_send_get_resp: send failure\n");

	va_end(vl);

	return(rc);
}

int smtp_host_test_mailfrom_rcptto(int sd, int timeout, char *mailfrom, char *mbox, char *dom, int *smtprc)
{	int	rc = -1;

	if((*smtprc = smtp_send_get_resp(sd,timeout,250,"helo %s\r\n",gHostname)) == 250 &&
		(*smtprc = smtp_send_get_resp(sd,timeout,250,"mail from:<%s>\r\n",mailfrom)) == 250 &&
		(*smtprc = smtp_send_get_resp(sd,timeout,250,"rcpt to:<%s@%s>\r\n",mbox,dom)) == 250)
		rc = 1;
	else
		rc = (*smtprc > 0 ? 0 : -1);

	return(rc);
}

int smtp_host_is_deliverable(char *mbox, char *dom, long hostip, int *smtprc)
{	int	rc = -1;	/* 1 = success, 0 = failure, -1 = unreachable */
	int	sd = NetSockOpenTcpPeer(hostip,25);
	int	timeout = 90;

	if(sd != INVALID_SOCKET && (*smtprc = smtp_get_resp(sd,90,220)) == 220)
	{
		if((rc = smtp_host_test_mailfrom_rcptto(sd,timeout,"",mbox,dom,smtprc)) == 0 &&
			smtp_send_get_resp(sd,timeout,250,"rset\r\n") == 250)
		{	char	*adr;
		
			asprintf(&adr,"postmaster@%s",gHostname);
			if(adr != NULL)
			{
				rc = smtp_host_test_mailfrom_rcptto(sd,timeout,adr,mbox,dom,smtprc);
				free(adr);
			}
		}
	}
	else if(sd == INVALID_SOCKET)
		rc = (errno == ECONNREFUSED ? 0 : -1);
	else
		rc = (*smtprc > 0 ? 0 : -1);

	if(sd != INVALID_SOCKET)
		NetSockPrintf(sd,"quit\r\n");

	NetSockClose(&sd);

	return(rc);
}

int smtp_mx_is_deliverable(mx_rr *rr, char *mbox, char *dom, int *smtprc)
{	int	tst = -1;
	int	j;

	mlfi_debug("\tMX %u %s\n",rr->pref,rr->name);
	rr->visited = 1;
	for(j=0; tst==-1 && j<rr->qty; j++)
	{
		mlfi_debug("\t\tA %s\n",ip2str(rr->host[j].ip));
		if(ifi_islocalip(rr->host[j].ip))
		{
			tst = 2;
			*smtprc = 250;
		}
		else
			tst = smtp_host_is_deliverable(mbox,dom,rr->host[j].ip,smtprc);
		switch(tst)
		{
			case 2:
				mlfi_debug("\t\tPassed - Local Host\n");
				break;
			case 1:
				mlfi_debug("\t\tPassed - Foreign Host: %d\n",*smtprc);
				break;
			case 0:
				mlfi_debug("\t\tFailed: %d\n",*smtprc);
				break;
			default:
				mlfi_debug("\t\tUnreachable\n");
				break;
		}
	}

	return(tst);
}

int smtp_email_address_is_deliverable(const res_state statp, char *mbox, char *dom, int *smtprc)
{	int		rc = 0;
	mx_rr_list	*rrl = calloc(1,sizeof(mx_rr_list));
	int		i,j,l,tst = -1;
	mx_rr		*rr;

#ifdef OS_hpux
	sigignore(SIGPIPE);
#endif

	if(rrl != NULL && mbox != NULL && dom != NULL)
	{
		memset(rrl,0,sizeof(mx_rr_list));
		mx_get_rr_bydomain(statp,rrl,dom);

		if(rrl->qty == 0)
			mlfi_debug("no mx records\n");
		else
		{
			/* test all MX RRs */
			for(i=0; tst==-1 && i<rrl->qty; i++)
			{
				/* find highest priority non-visited MX RR */
				for(rr=NULL,j=0,l=-1; j<rrl->qty; j++)
				{
					if(!rrl->mx[j].visited && (l == -1 || rrl->mx[j].pref <= l))
					{
						l = rrl->mx[j].pref;
						rr = &rrl->mx[j];
					}
				}

				/* test MX */
				if(rr != NULL)
					tst = smtp_mx_is_deliverable(rr,mbox,dom,smtprc);
			}
			if(tst == 1 || tst == 2)
				rc = 1;
		}
	}

	if(rrl != NULL)
		free(rrl);

	return(rc);
}

/*--------------------------------------------------------------------*
 * $Log: smtp.c,v $
 * Revision 1.26  2005/11/22 02:54:37  neal
 * neal - 051121 - patch submitted by Claus Assmann to fix RFC 2821 violation
 *
 * Revision 1.25  2005/07/18 00:55:13  neal
 * neal - 050717 - Wall cleanup
 *
 * Revision 1.24  2005/04/03 18:45:48  neal
 * neal - 050403 - change sender verification to use postmaster@hostname instead of bob@disney.com
 *
 * Revision 1.23  2004/12/19 03:00:52  neal
 * neal - 041218 - do not *smtprc remember the rset result code
 *
 * Revision 1.22  2004/11/28 21:27:27  neal
 * neal - 041128 - change for hpux
 *
 * Revision 1.21  2004/11/26 04:25:36  neal
 * neal - 041125 - formatting change
 *
 * Revision 1.20  2004/11/26 00:12:52  neal
 * neal - 041125 - add res_n support. return result code 250 if is local net host
 *
 * Revision 1.19  2004/08/18 01:59:09  neal
 * neal - 040817 - to combat rfc ignorant mta hosts, try twice to negotiate an accepted
 * 	"mail from:, rcpt to:" sequence, first with <>, then with <bob@disney.com>
 * 	if that fails.
 *
 * Revision 1.18  2003/10/06 05:33:24  neal
 * neal - 031006 - smtp sender validation will reject if the MX host refuses the socket connection
 *
 * Revision 1.17  2003/09/06 19:02:10  neal
 * neal - 030906 - mod ipfwmtad nolonger runs unless uid == 0. mod spamilter logging to record reject reason in field 5. add ipfwmtad cli operators for addition and removal queuing of ipaddress to and from the fwblock list. mod spamilter all extended smtp error codes are now 5.7.1
 *
 * Revision 1.16  2003/05/28 03:37:58  neal
 * neal - 030527 - include license in all files
 *
 * Revision 1.15  2003/05/09 01:54:57  neal
 * neal - 030508 - moe betta handling of non-220 MTA connect codes. (indicate failure instead of unreachable)
 *
 * Revision 1.14  2003/05/02 02:40:38  neal
 * neal - 030501 - fix display for sender validation MTA return code
 *
 * Revision 1.13  2003/05/01 02:31:35  neal
 * neal - 030430 - better smtp send delivery test handling
 *
 * Revision 1.12  2003/04/24 17:23:23  neal
 * neal - 030424 - move gethostname to a global
 *
 * Revision 1.11  2003/04/24 04:04:20  neal
 * neal - 030423 - always try to "quit" and close a socket
 *
 * Revision 1.10  2003/04/18 02:52:17  neal
 * neal - 030417 - init tst
 *
 * Revision 1.9  2003/04/18 02:32:33  neal
 * neal - 030417 - do MX testing in Preference order
 *
 * Revision 1.8  2003/04/17 04:15:57  neal
 * neal - 030416 - follow rfc2821 regarding using an A RR when no MX RRs are returned for a domain
 *
 * Revision 1.7  2003/04/16 03:38:16  neal
 * neal - 030415 - remove bogus debug junk
 *
 * Revision 1.6  2003/04/14 01:08:38  neal
 * neal - 030413 - move black and white lists to flat ascii files from sql.
 *
 * Revision 1.5  2003/03/24 04:13:14  neal
 * neal - 030323 - more bad pointer fixes, etc
 *
 * Revision 1.4  2003/03/24 02:23:09  neal
 * neal - 030323 - bad pointer fixes, etc
 *
 * Revision 1.3  2003/03/24 00:46:26  neal
 * neal - 030323 - add realtime black/white list of sender/recipient email addresses
 *
 * Revision 1.2  2003/03/20 06:42:24  neal
 * neal - 030320 - add accept/reject/spam logging. make "Sender address deliverable" check work for local domain.
 *
 * Revision 1.1  2003/03/02 04:11:49  neal
 * neal - 030301 - add smtp sender deliverablity check
 *
 *--------------------------------------------------------------------*/
