/*--------------------------------------------------------------------*
 *
 * Developed by;
 *	Neal Horman - http://www.wanlink.com
 *	Copyright (c) 2003 Neal Horman. All Rights Reserved
 *
 *	Redistribution and use in source and binary forms, with or without
 *	modification, are permitted provided that the following conditions
 *	are met:
 *	1. Redistributions of source code must retain the above copyright
 *	   notice, this list of conditions and the following disclaimer.
 *	2. Redistributions in binary form must reproduce the above copyright
 *	   notice, this list of conditions and the following disclaimer in the
 *	   documentation and/or other materials provided with the distribution.
 *	3. All advertising materials mentioning features or use of this software
 *	   must display the following acknowledgement:
 *	This product includes software developed by Neal Horman.
 *	4. Neither the name Neal Horman nor the names of any contributors
 *	   may be used to endorse or promote products derived from this software
 *	   without specific prior written permission.
 *	
 *	THIS SOFTWARE IS PROVIDED BY NEAL HORMAN AND ANY CONTRIBUTORS ``AS IS'' AND
 *	ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *	IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *	ARE DISCLAIMED.  IN NO EVENT SHALL NEAL HORMAN OR ANY CONTRIBUTORS BE LIABLE
 *	FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *	DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 *	OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 *	LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 *	OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 *	SUCH DAMAGE.
 *
 *	CVSID:  $Id: spamilter.c,v 1.36 2005/11/24 20:31:38 neal Exp $
 *
 * DESCRIPTION:
 *	application:	spamilter
 *	module:		spamilter.c
 *--------------------------------------------------------------------*/

static char const cvsid[] = "@(#)$Id: spamilter.c,v 1.36 2005/11/24 20:31:38 neal Exp $";

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <syslog.h>
#include <sysexits.h>
#include <string.h>
#include <sys/types.h>
#include <pwd.h>

#include "spamilter.h"
#include "dnsbl.h"
#include "hndlrs.h"
#include "misc.h"

int	gDebug			= 0;
char	*gPolicyUrl		= "http://www.somedomain.com/policy.html";
char	*gDbpath		= "/var/db/spamilter";
char	*gConfpath		= "/etc/spamilter.rc";
char	*gMlficonn		= "inet:7726@localhost";
int	gDnsBlChk		= 1;
int	gSmtpSndrChk		= 1;
char	*gSmtpSndrChkAction	= "Reject";
int	gMtaHostChk		= 1;
int	gMtaHostIpfw		= 0;
int	gMtaHostIpfwNominate	= 0;
int	gMtaHostIpChk		= 0;
int	gMsExtChk		= 1;
char	*gMsExtChkAction	= "Reject";
char	gHostnameBuf[1024];	/* hope this is big enough! */
char	*gHostname		= gHostnameBuf;
char	*gUserName		= "nobody";
#ifdef SUPPORT_POPAUTH
char	*gPopAuthChk		= NULL;
#endif
#ifdef SUPPORT_LIBSPF
int	gMtaSpfChk		= 0;
#endif

struct smfiDesc mlfi =
{
	"Spamilter",	/* filter name */
	SMFI_VERSION,	/* version code -- do not change */
	SMFIF_ADDHDRS | SMFIF_CHGHDRS | SMFIF_CHGBODY,	/* flags */
	mlfi_connect,	/* connection info filter */
	mlfi_helo,	/* SMTP HELO command filter */
	mlfi_envfrom,	/* envelope sender filter */
	mlfi_envrcpt,	/* envelope recipient filter */
	mlfi_header,	/* header filter */
	NULL,		/* end of header */
	mlfi_body,	/* body block filter */
	mlfi_eom,	/* end of message */
	mlfi_abort,	/* message aborted */
	mlfi_close	/* connection cleanup */
};

#define SetKeyValStr(k,v,n,d) { if(strlen(k) && strlen(v) && strcasecmp((k),(n)) == 0) (d) = strdup((v)); }
#define SetKeyValInt(k,v,n,d) { if(strlen(k) && strlen(v) && strcasecmp((k),(n)) == 0) (d) = atoi((v)); }

#define ShowKeyValStr(k,v) { printf("%s = '%s'\n",(k),(v)); }
#define ShowKeyValInt(k,v) { printf("%s = %u\n",(k),(v)); }

void getconf(char *confpath)
{	FILE	*fin = fopen(confpath,"r");
	char	*str;
	char	buf[1024];
	char	key[1024];
	char	val[1024];

	if(fin != NULL)
	{
		while(!feof(fin))
		{
			fgets(buf,sizeof(buf),fin);
			
			str = strchr(buf,'#');
			if(str != NULL)
			{
				*(str--) = '\0';
				while(str >= buf && (*str ==' ' || *str == '\t'))
					*(str--) = '\0';
			}

			if(strlen(buf))
			{
				str = mlfi_strcpyadv(key,sizeof(key),buf,'=');
				str = mlfi_strcpyadv(val,sizeof(val),str,'=');

				SetKeyValStr(key,val,"UserName",gUserName);
				SetKeyValStr(key,val,"PolicyUrl",gPolicyUrl);
				SetKeyValStr(key,val,"DbPath",gDbpath);
				SetKeyValStr(key,val,"Conn",gMlficonn);
				SetKeyValInt(key,val,"DnsBlChk",gDnsBlChk);
				SetKeyValInt(key,val,"SmtpSndrChk",gSmtpSndrChk);
				SetKeyValStr(key,val,"SmtpSndrChkAction",gSmtpSndrChkAction);
				SetKeyValInt(key,val,"MtaHostChk",gMtaHostChk);
				SetKeyValInt(key,val,"MtaHostIpfw",gMtaHostIpfw);
				SetKeyValInt(key,val,"MtaHostIpfwNominate",gMtaHostIpfwNominate);
				SetKeyValInt(key,val,"MtaHostIpChk",gMtaHostIpChk);
#ifdef SUPPORT_LIBSPF
				SetKeyValInt(key,val,"MtaSpfChk",gMtaSpfChk);
#endif

				SetKeyValInt(key,val,"MsExtChk",gMsExtChk);
				SetKeyValStr(key,val,"MsExtChkAction",gMsExtChkAction);
#ifdef SUPPORT_POPAUTH
				SetKeyValStr(key,val,"PopAuthChk",gPopAuthChk);
#endif
			}
		}
		fclose(fin);
	}
	else
		printf("Warning! Unable to open config file '%s', using compiled defaults.\n",confpath);
}

void usage()
{
	printf("spamilter [-c config] [-d 1] \n");
	printf("\tWhere;\n\t-c specifies a config filename to read at startup\n");
	printf("\t-d debug mode.\n");
}

int main_filter()
{	char	*fname = NULL;
	int	rc;
	pid_t	pid = getpid();

	asprintf(&fname,"/tmp/%s.pid",mlfi.xxfi_name);
	if(fname != NULL)
	{	FILE	*fpid = fopen(fname,"w");

		if(fpid != NULL)
		{
			fprintf(fpid,"%u",pid);
			fflush(fpid);
			fclose(fpid);
		}
	}

	printf("PID: %u\n",pid);
	rc = smfi_main();

	if(fname != NULL)
	{
		unlink(fname);
		free(fname);
	}

	return(rc);
}

int main(int argc, char *argv[])
{	int		c;
	struct passwd	*pw = NULL;
	int		uid = getuid();

	openlog(mlfi.xxfi_name, LOG_NDELAY|LOG_PID, LOG_DAEMON);

	/* Process command line options */
	while ((c = getopt(argc, argv, "d:c:")) != -1)
	{
		switch (c)
		{
			case 'c':
				if (optarg != NULL && *optarg != '\0')
					gConfpath = optarg;
				break;
			case 'd': /* debug */
				if(optarg != NULL && *optarg)
					gDebug = atoi(optarg);
				break;
			default:
				usage();
				exit(0);
				break;
		}
	}

	getconf(gConfpath);

	if(uid == 0) /* if root, drop privs */
	{
		if((pw = getpwnam(gUserName)) == NULL)
		{
			fprintf(stderr,"Fatal error - Unable to get user '%s' identity information",gUserName);
			exit(1);
		}
		else if(setgid(pw->pw_gid) != 0 || setuid(pw->pw_uid) != 0)
		{
			fprintf(stderr,"Fatal error - Unable to switch user identity to '%s'",gUserName);
			exit(2);
		}
		else
			uid = pw->pw_uid;
	}
	pw = getpwuid(uid);

	printf("\nStarting %s\n",mlfi.xxfi_name);
	printf("Running as user '%s/%s'\n",pw->pw_name,pw->pw_gecos);
	ShowKeyValStr("PolicyUrl",gPolicyUrl);
	ShowKeyValStr("DbPath",gDbpath);
	ShowKeyValStr("Conn",gMlficonn);
	ShowKeyValInt("DnsBlChk",gDnsBlChk);
	ShowKeyValInt("SmtpSndrChk",gSmtpSndrChk);
	ShowKeyValStr("SmtpSndrChkAction",gSmtpSndrChkAction);
	ShowKeyValInt("MtaHostChk",gMtaHostChk);
	ShowKeyValInt("MtaHostIpfw",gMtaHostIpfw);
	ShowKeyValInt("MtaHostIpfwNominate",gMtaHostIpfwNominate);
	ShowKeyValInt("MtaHostIpChk",gMtaHostIpChk);
#ifdef SUPPORT_LIBSPF
	ShowKeyValInt("MtaSpfChk",gMtaSpfChk);
#endif
	ShowKeyValInt("MsExtChk",gMsExtChk);
	ShowKeyValStr("MsExtChkAction",gMsExtChkAction);
#ifdef SUPPORT_POPAUTH
	ShowKeyValStr("PopAuthChk",gPopAuthChk);
#endif

	gethostname(gHostnameBuf,sizeof(gHostnameBuf)-1);

	/* for silly hosts that don't fully quallify their hostname */
	if(strchr(gHostnameBuf,'.') == NULL)
	{
		/* append the default domain name from the resolver library */
		res_init();
		strncat(gHostnameBuf,".",(sizeof(gHostnameBuf)-1)-strlen(gHostnameBuf));
		strncat(gHostnameBuf,_res.defdname,(sizeof(gHostnameBuf)-1)-strlen(gHostnameBuf));
	}
	printf("Hostname: '%s'\n",gHostname);


	/* if not doing attachment checks, don't do body processing */
	if(!gMsExtChk)
		mlfi.xxfi_body = NULL;

	c = 0;
	smfi_setconn(gMlficonn);
	if (smfi_register(mlfi) == MI_FAILURE)
	{
		fprintf(stderr, "smfi_register failed\n");
		exit(EX_UNAVAILABLE);
	}
	else
	{
		if(!gDebug)
		{
			if(fork() == 0)
			{
				close(STDIN_FILENO);
				close(STDOUT_FILENO);
				close(STDERR_FILENO);
				c = main_filter();
			}
		}
		else
			c = main_filter();
	}

	return(c);
}

/*--------------------------------------------------------------------*
 * $Log: spamilter.c,v $
 * Revision 1.36  2005/11/24 20:31:38  neal
 * neal - 051124 - changes for dns
 *
 * Revision 1.35  2004/11/22 20:35:37  neal
 * neal - 041121 - if not doing attachment checks, do not do body processing
 *
 * Revision 1.34  2004/11/05 03:40:51  neal
 * neal - 041104 - add compile time options for libspf and popauth
 *
 * Revision 1.33  2004/04/10 06:03:12  neal
 * neal - 040410 - crashland SPF. change X-Milter header to provide more information
 *
 * Revision 1.32  2004/03/19 03:20:50  neal
 * neal - 040318 - add support for pop-before-smtp or popauth
 *
 * Revision 1.31  2004/01/27 22:24:07  neal
 * neal - 040127 - fix blacklisted error printf specifier
 *
 * Revision 1.30  2004/01/23 07:02:54  neal
 * neal - 040123 - make sure the host name is fully qualified
 *
 * Revision 1.29  2004/01/04 01:32:52  neal
 * neal - 040103 - remove gMtaUrl hyperlink support in favor of gPolicyUrl and anchors
 *
 * Revision 1.28  2004/01/02 17:51:08  neal
 * neal - 040102 - add global config.h include
 *
 * Revision 1.27  2003/10/13 00:05:51  neal
 * neal - 031012 - change the compiled default policy urls
 *
 * Revision 1.26  2003/10/08 18:01:40  neal
 * neal - 031008 - add support for writing pid to /tmp/Spamilter.pid
 *
 * Revision 1.25  2003/10/04 16:18:27  neal
 * neal - 031004 - support for MtaHostIpChk and MtaHostIpfwNominate
 *
 * Revision 1.24  2003/09/19 04:55:29  neal
 * * fix -  don't free the reject "reason" pointer more that once per allocation. ;)
 * * add - global SmtpSndrChkAction and MsExtChkAction with 'Tag' or 'Reject' actions in
 * 	spamilter.rc to optionally tag a given email instead of rejecting it.
 *
 * Revision 1.23  2003/09/02 16:36:32  neal
 * neal - 030903 - um.. read the gMtaHostIpfw setting from the config file!
 *
 * Revision 1.22  2003/09/02 07:12:10  neal
 * neal - 030902 - fix segfaults. add MtaHostIpfw filter
 *
 * Revision 1.21  2003/08/20 22:30:09  neal
 * neal - 030820 - add Microsoft file extension attachment vunerablility filter
 *
 * Revision 1.20  2003/08/10 21:53:00  neal
 * neal - 030810 - don\'t cary the sendmail context around to places that only need the private context
 *
 * Revision 1.19  2003/05/28 03:37:58  neal
 * neal - 030527 - include license in all files
 *
 * Revision 1.18  2003/05/04 06:20:46  neal
 * neal - 030504 - do some cleanup before release
 *
 * Revision 1.17  2003/04/24 18:59:38  neal
 * neal - 030424 - allow/handle comments in the config file
 *
 * Revision 1.16  2003/04/24 17:23:23  neal
 * neal - 030424 - move gethostname to a global
 *
 * Revision 1.15  2003/04/16 03:51:38  neal
 * neal - 030415 - fix getconf. mlfi_stradv no longer will copy CR and LF
 *
 * Revision 1.14  2003/04/16 03:36:05  neal
 * neal - 030415 - move program options into config file
 *
 * Revision 1.13  2003/04/14 02:03:06  neal
 * neal - 030413 - make MTA hostname checking optional
 *
 * Revision 1.12  2003/04/14 01:08:38  neal
 * neal - 030413 - move black and white lists to flat ascii files from sql.
 *
 * Revision 1.11  2003/04/08 03:40:54  neal
 * neal - 030407 - add a url for Invalid MTA contitions
 *
 * Revision 1.10  2003/03/24 02:23:09  neal
 * neal - 030323 - bad pointer fixes, etc
 *
 * Revision 1.9  2003/03/24 00:46:26  neal
 * neal - 030323 - add realtime black/white list of sender/recipient email addresses
 *
 * Revision 1.8  2003/03/20 06:42:24  neal
 * neal - 030320 - add accept/reject/spam logging. make "Sender address deliverable" check work for local domain.
 *
 * Revision 1.7  2003/03/02 04:11:49  neal
 * neal - 030301 - add smtp sender deliverablity check
 *
 * Revision 1.6  2003/03/01 18:12:45  neal
 * neal - 030301 - optionalize dnsbl all operations
 *
 * Revision 1.5  2003/02/24 08:16:21  neal
 * neal - 030224 - added dnsbl rejection point to RCPT stage, preferenced over connect stage
 *
 * Revision 1.4  2003/02/24 07:27:40  neal
 * neal - 030224 - not debug mode by default
 *
 * Revision 1.3  2003/02/24 04:11:33  neal
 * neal - 030223 - add header/footers to all files
 *
 *--------------------------------------------------------------------*/
