/*--------------------------------------------------------------------*
 *
 * Developed by;
 *	Neal Horman - http://www.wanlink.com
 *	Copyright (c) 2003 Neal Horman. All Rights Reserved
 *
 *	Redistribution and use in source and binary forms, with or without
 *	modification, are permitted provided that the following conditions
 *	are met:
 *	1. Redistributions of source code must retain the above copyright
 *	   notice, this list of conditions and the following disclaimer.
 *	2. Redistributions in binary form must reproduce the above copyright
 *	   notice, this list of conditions and the following disclaimer in the
 *	   documentation and/or other materials provided with the distribution.
 *	3. All advertising materials mentioning features or use of this software
 *	   must display the following acknowledgement:
 *	This product includes software developed by Neal Horman.
 *	4. Neither the name Neal Horman nor the names of any contributors
 *	   may be used to endorse or promote products derived from this software
 *	   without specific prior written permission.
 *	
 *	THIS SOFTWARE IS PROVIDED BY NEAL HORMAN AND ANY CONTRIBUTORS ``AS IS'' AND
 *	ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *	IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *	ARE DISCLAIMED.  IN NO EVENT SHALL NEAL HORMAN OR ANY CONTRIBUTORS BE LIABLE
 *	FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *	DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 *	OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 *	LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 *	OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 *	SUCH DAMAGE.
 *
 *	CVSID:  $Id: spamilter.h,v 1.38 2004/12/12 22:14:16 neal Exp $
 *
 * DESCRIPTION:
 *	application:	spamilter
 *	module:		spamilter.h
 *--------------------------------------------------------------------*/

#ifndef _SPAMILTER_H_
#define _SPAMILTER_H_

	#include "libmilter/mfapi.h"

	#define SYSLOGF LOG_LOCAL6
	#define LOGFAIL 1
	#define LOGREJ 1

	#include "config.h"

	#include <sys/types.h>
	#include <sys/socket.h>
	#include <netinet/in.h>

	typedef struct _mlfiPriv
	{
		struct sockaddr	ip;
		char		*ipstr;
		char		*iphostname;
		char		*xstatus;
		int		dnsblcount;
		char		*helo;
		int		smtprc;
		char		*sndr;
		int		sndraction;
		int		sndrreject;
		char		*rcpt;
		int		rcptaction;
		char		*subject;
		int		bwlistfdsndr;
		int		bwlistfdrcpt;
		struct _rblhost	*dnsrblhosts;
		int		dnsrblhostqty;
		struct _rblhost	**dnsrblmatch;
		int		dnsrblmatchqty;
		int		reject;
		char		rcptactionexec[1024];
		char		sndractionexec[1024];
		char		*body;
		int		bodylen;
		int		MsExtFound;
		int		SmtpSndrChkFail;
		int		islocalnethost;
		res_state	statp;
#ifdef SUPPORT_LIBSPF
		int		spf_rc;
		char		*spf_rs;
		char		*spf_error;
		char		*spf_explain;
#endif
		char		*badextlist;
		int		badextqty;
	} mlfiPriv;

	#define MLFIPRIV ((mlfiPriv *) smfi_getpriv(ctx))

	struct smfiDesc mlfi;		/* forward declaration */

	extern int gDebug;
	extern char *gPolicyUrl;		/* policy url */
	extern char *gDbpath;			/* /var/db/spamiter */
	extern char *gConfpath;			/* /etc/spamilter.rc */
	extern char *gMlfiConn;			/* inet:7726@localhost */
	extern int gDnsBlChk;			/* dns blacklist checking */
	extern int gSmtpSndrChk;		/* do smtp sender is deliverable checks */
	extern char *gSmtpSndrChkAction;	/* action to take when sender deliverable checks fail */
	extern int gMtaHostChk;			/* do MTA hostname checking */
	extern int gMtaHostIpfw;		/* do Ipfw inserts if MTA hostname check fails */
	extern int gMtaHostIpfwNominate;	/* do Ipfw inserts based on connects per minute */
	extern int gMtaHostIpChk;		/* do MTA hostname to connect ip address resolution checking */
	extern int gMsExtChk;			/* do Microsoft File Extension vulnerablity checks */
	extern char *gMsExtChkAction;		/* action to take when vulnerable Microsoft attachemnts are found */
	extern char *gHostname;			/* local hostname */
#ifdef SUPPORT_POPAUTH
	extern char *gPopAuthChk;		/* path/filename of pop-before-smtp berkely db */
#endif
#ifdef SUPPORT_LIBSPF
	extern int gMtaSpfChk;			/* do SPF MTA host checking using libspf */
#endif

	enum { MSE_A_TAG, MSE_A_REJECT };

#endif

/*--------------------------------------------------------------------*
 * $Log: spamilter.h,v $
 * Revision 1.38  2004/12/12 22:14:16  neal
 * neal - 041212 - add support for reading MsExtChk file list from db.extensions in lue of being hard coded
 *
 * Revision 1.37  2004/11/26 00:19:40  neal
 * neal - 041125 - add res_n support
 *
 * Revision 1.36  2004/11/05 03:41:28  neal
 * neal - 041104 - add compile time options for libspf and popauth
 *
 * Revision 1.35  2004/04/10 06:03:12  neal
 * neal - 040410 - crashland SPF. change X-Milter header to provide more information
 *
 * Revision 1.34  2004/03/30 18:42:17  neal
 * neal - 040330 - fold the result of the popauth check into islocalnethost status. commonize code to do mtaipfwd client connections. add ip address as mta hostname check, and recipient domain name as mta hostname check, both based on MtaHostChk config option
 *
 * Revision 1.33  2004/03/19 04:14:49  neal
 * neal - 040318 - cache the result of ifi_islocalhost instead of calling it a bazillion times
 *
 * Revision 1.32  2004/03/19 03:20:50  neal
 * neal - 040318 - add support for pop-before-smtp or popauth
 *
 * Revision 1.31  2004/01/04 01:32:52  neal
 * neal - 040103 - remove gMtaUrl hyperlink support in favor of gPolicyUrl and anchors
 *
 * Revision 1.30  2003/10/28 06:31:36  neal
 * neal - 031028 - fix inet_ntoa segfault on solaris
 *
 * Revision 1.29  2003/10/04 16:18:27  neal
 * neal - 031004 - support for MtaHostIpChk and MtaHostIpfwNominate
 *
 * Revision 1.28  2003/09/19 04:55:29  neal
 * * fix -  don't free the reject "reason" pointer more that once per allocation. ;)
 * * add - global SmtpSndrChkAction and MsExtChkAction with 'Tag' or 'Reject' actions in
 * 	spamilter.rc to optionally tag a given email instead of rejecting it.
 *
 * Revision 1.27  2003/09/02 07:12:10  neal
 * neal - 030902 - fix segfaults. add MtaHostIpfw filter
 *
 * Revision 1.26  2003/08/20 22:30:09  neal
 * neal - 030820 - add Microsoft file extension attachment vunerablility filter
 *
 * Revision 1.25  2003/08/10 21:53:00  neal
 * neal - 030810 - don\'t cary the sendmail context around to places that only need the private context
 *
 * Revision 1.24  2003/07/05 01:01:53  neal
 * neal - 030704 - recipient action now takes precidence over the sender action. add Exec action. remove partially implemented honeypot code in preference of Exec action
 *
 * Revision 1.23  2003/05/28 03:37:58  neal
 * neal - 030527 - include license in all files
 *
 * Revision 1.22  2003/05/04 06:20:47  neal
 * neal - 030504 - do some cleanup before release
 *
 * Revision 1.21  2003/05/01 02:31:35  neal
 * neal - 030430 - better smtp send delivery test handling
 *
 * Revision 1.20  2003/04/24 17:23:23  neal
 * neal - 030424 - move gethostname to a global
 *
 * Revision 1.19  2003/04/24 04:11:02  neal
 * neal - 030423 - move bwlist reject from envfrom to envrcpt for logging purposes
 *
 * Revision 1.18  2003/04/17 05:08:35  neal
 * neal - 030417 - move sender delivery rejection into envrcpt
 *
 * Revision 1.17  2003/04/16 03:36:05  neal
 * neal - 030415 - move program options into config file
 *
 * Revision 1.16  2003/04/14 03:52:07  neal
 * neal - 030413 - move the rdnsbl hosts to a flat ascii file
 *
 * Revision 1.15  2003/04/14 02:03:06  neal
 * neal - 030413 - make MTA hostname checking optional
 *
 * Revision 1.14  2003/04/14 01:08:38  neal
 * neal - 030413 - move black and white lists to flat ascii files from sql.
 *
 * Revision 1.13  2003/04/08 03:40:54  neal
 * neal - 030407 - add a url for Invalid MTA contitions
 *
 * Revision 1.12  2003/03/31 05:49:59  neal
 * neal - 030330 - do not link the milter to the bind resolver library, it segfaults (and is is huge!)
 *
 * Revision 1.11  2003/03/31 04:39:50  neal
 * neal - 030330 - add MTA hostname validation
 *
 * Revision 1.10  2003/03/30 05:45:59  neal
 * neal - 030329 - add recipient verifycation logging
 *
 * Revision 1.9  2003/03/24 02:23:09  neal
 * neal - 030323 - bad pointer fixes, etc
 *
 * Revision 1.8  2003/03/24 00:46:26  neal
 * neal - 030323 - add realtime black/white list of sender/recipient email addresses
 *
 * Revision 1.7  2003/03/20 06:42:24  neal
 * neal - 030320 - add accept/reject/spam logging. make "Sender address deliverable" check work for local domain.
 *
 * Revision 1.6  2003/03/02 04:11:49  neal
 * neal - 030301 - add smtp sender deliverablity check
 *
 * Revision 1.5  2003/02/24 08:16:21  neal
 * neal - 030224 - added dnsbl rejection point to RCPT stage, preferenced over connect stage
 *
 * Revision 1.4  2003/02/24 05:04:42  neal
 * neal - 030223 - remove individual dnsbl zone tracking
 *
 * Revision 1.3  2003/02/24 04:11:33  neal
 * neal - 030223 - add header/footers to all files
 *
 *--------------------------------------------------------------------*/
